CREATE DATABASE StokYonetimDB;
GO

USE StokYonetimDB;
GO

CREATE TABLE Kategoriler (
    Id INT PRIMARY KEY IDENTITY(1,1),
    Ad NVARCHAR(100) NOT NULL,
    Aciklama NVARCHAR(250) NULL
);

CREATE TABLE Urunler (
    Id INT PRIMARY KEY IDENTITY(1,1),
    Ad NVARCHAR(150) NOT NULL,
    Marka NVARCHAR(100) NULL,
    Model NVARCHAR(100) NULL,
    Barkod VARCHAR(50) UNIQUE,
    AlisFiyati DECIMAL(18, 2) NULL,
    SatisFiyati DECIMAL(18, 2) NOT NULL,
    StokAdedi INT NOT NULL DEFAULT 0,
    KategoriId INT FOREIGN KEY REFERENCES Kategoriler(Id),
    AktifMi BIT NOT NULL DEFAULT 1
);

CREATE TABLE Kullanicilar (
    Id INT PRIMARY KEY IDENTITY(1,1),
    KullaniciAdi VARCHAR(50) NOT NULL UNIQUE,
    SifreHash VARBINARY(MAX) NOT NULL, -- rnek olarak VARBINARY. Gvenli bir hash algoritmas kullanlacak.
    AdSoyad NVARCHAR(100) NULL,
    Rol VARCHAR(20) NOT NULL -- 'Admin', 'Kullanici'
);

CREATE TABLE StokHareketleri (
    Id INT PRIMARY KEY IDENTITY(1,1),
    UrunId INT NOT NULL FOREIGN KEY REFERENCES Urunler(Id),
    HareketTipi VARCHAR(10) NOT NULL, -- 'GIRIS' veya 'CIKIS'
    Miktar INT NOT NULL,
    BirimFiyat DECIMAL(18, 2) NULL,
    Tarih DATETIME NOT NULL DEFAULT GETDATE(),
    KullaniciId INT NOT NULL FOREIGN KEY REFERENCES Kullanicilar(Id)
);

IF NOT EXISTS (SELECT 1 FROM Kullanicilar WHERE KullaniciAdi = 'admin')
BEGIN
    INSERT INTO Kullanicilar (KullaniciAdi, SifreHash, AdSoyad, Rol)
    VALUES (
        'admin',                              -- Kullanc Ad
        0x03AC674216F3E15C761EE1A5E255F067953623C8B388B4459E13F978D7C846F4,       -- Panodaki yeni hash deeri
        'Sistem Admini',                      -- Ad Soyad
        'Admin'                               -- Rol
    );
    PRINT 'Admin kullancs baaryla eklendi.';
END
ELSE
BEGIN
    PRINT 'Admin kullancs zaten mevcut.';
END
GO